
drop function if exists public.ufd_est_prod_tbl_desc_pre_vencidos(integer, integer, character varying);
drop function if exists public.ufd_est_prod_tbl_desc_pre_vencidos(integer, integer, character varying, integer);

-- Type: rs_temp_return_rec
DO $$
BEGIN
	IF EXISTS (SELECT 1 FROM pg_type WHERE typname = 'rs_temp_return_rec') THEN
		DROP TYPE rs_temp_return_rec cascade;
	END IF;
END$$;

CREATE TYPE public.rs_temp_return_rec AS(	
	cd_tbl_desc integer,
	perc_desc double precision,
	perc_desc_max double precision,
	tp_nivel INTEGER
	);

ALTER TYPE public.rs_temp_return_rec OWNER TO postgres;

/*
=======================================================================================
'Nível Classificação.: INFORMAÇÃO RESTRITA
'Versão..............: 20221106
'Job.................:  
'Nome................: [UFD_EST_PROD_TBL_DESC_FORMA_PGTO]
'Objetivo............: 
'Tabelas.............: 
'Dt Criação..........: 
'Dt Ult Alteracão....: 2022-11-06
'Alterado por........: Marcos barros
=======================================================================================
Tag #I002 - Merge @TP_ORIG_VENDA e @USA_DESCONTO_PROPZ_IDENT

-- Function: public.ufd_est_prod_tbl_desc_pre_vencidos(integer, integer, character varying)

-- DROP FUNCTION public.ufd_est_prod_tbl_desc_pre_vencidos(integer, integer, character varying);
*/

CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_pre_vencidos(
    integer,
    integer,
    character varying,
	integer
	)
  RETURNS SETOF rs_temp_return_rec AS
$BODY$
	
declare
---------------------------------------------------------
----declara as variáveis que estão no cabeçalho da função
---------------------------------------------------------
int_cd_emp				alias for $1; 
int_cd_filial			alias for $2;
var_ean					alias for $3;
int_cd_forma_pgto       alias for $4;
---------------------------------------------------------
----fim
---------------------------------------------------------

--var_trabalhacomdescontoformadepagamento 	integer;


returnrec rs_temp_return_rec;
int_vencido integer default 0;

begin-- inicio dos blocos da função
    -------------------------------------------------------------------------------------------------------------------------------    
    -- criação da tabela de retorno
    ------------------------------------------------------------------------------------------------------------------------------- 	
	begin
		create temporary table rs_temp_return_rec 
		(
		cd_tbl_desc 		int,
		perc_desc		double precision,
		perc_desc_max		double precision,
		tp_nivel		int
		);
		exception when others then
		truncate table rs_temp_return_rec;
	end;
    -------------------------------------------------------------------------------------------------------------------------------    
    --verifica o se o produto e pre-vencido
    ------------------------------------------------------------------------------------------------------------------------------- 

--	var_trabalhacomdescontoformadepagamento = coalesce((select coalesce(valor,'0')::integer from prc_filial_config where cd_chave = 'USA_DESCONTO_PGTO' and cd_filial = int_cd_filial), 0);
	
	int_vencido =(select flag_pre_vencidos from est_prod_cd_barra where cd_emp=int_cd_emp and cd_barra = var_ean limit 1);
	
	if int_vencido=0 then
		return;
	end if;
    

	-------------------------------------------------------------------------------------------------------------------------------    
    -------------------------------------------------------------------------------------------------------------------------------    
    -- criação da tabela de desconto
    ------------------------------------------------------------------------------------------------------------------------------- 
	begin
		create temporary table rs_tmp_desc 
		( 
			cd_tbl_desc 		integer,
			perc_desc		double precision,
			perc_desc_max		double precision,
			tp_nivel		integer
		);

		exception when others then
		truncate table rs_tmp_desc;
	end;
    -------------------------------------------------------------------------------------------------------------------------------    
    -------------------------------------------------------------------------------------------------------------------------------    
    insert into rs_tmp_desc 
    select distinct   
	   c.cd_tbl_desc as cd_tbl_desc,        
	   c.vlr_desc as perc_desc,    
	   c.vlr_desc as perc_desc_max,   
	   1 as tp_nivel 
    from 
	   est_prod_cpl_lote a
	   join est_prod_rem_pre_venc_it_lote b on 
	   a.cd_emp	 = b.cd_emp and 
	   a.cd_filial = b.cd_filial and 
	   a.cd_lote	 = b.cd_lote  
	   join est_prod_tbl_desc_pre_vencidos_cpl c on 
	   b.cd_emp	 = c.cd_emp and 
	   b.cd_tbl_desc = c.cd_tbl_desc  
    where
           (a.dt_valid::date - current_date::date ) ::numeric  between c.dias_fim and c.dias_ini
	   and b.ean = var_ean
	   and a.cd_filial = int_cd_filial
	   and a.cd_emp = int_cd_emp;

    -------------------------------------------------------------------------------------------------------------------------------    
    -------------------------------------------------------------------------------------------------------------------------------    
    
    insert into rs_tmp_desc     
    select distinct   
	   c.cd_tbl_desc as cd_tbl_desc,        
	   c.vlr_desc as perc_desc,    
	   c.vlr_desc as perc_desc_max,    
	   1 as tp_nivel      
    from 
	   est_prod_cpl_lote a
	   join est_prod_rem_pre_venc_it_lote b on 
	   a.cd_emp	 = b.cd_emp and 
	   a.cd_filial = b.cd_filial and 
	   a.cd_lote	 = b.cd_lote  
	   join est_prod_tbl_desc_pre_vencidos_cpl c on 
	   b.cd_emp	 = c.cd_emp and 
	   b.cd_tbl_desc = c.cd_tbl_desc  
    where
           a.qtde_prod between c.qtde_fim   and c.qtde_ini
	   and  b.ean = var_ean
	   and a.cd_filial = int_cd_filial
	   and a.cd_emp = int_cd_emp;

/*	   
	 if var_trabalhacomdescontoformadepagamento = 1 then  
			 
	
			delete from rs_tmp_desc a 
			 where not exists (select b.cd_emp
			      				 from est_prod_tbl_desc_forma_pgto b  
				    			where b.cd_tbl_desc   = a.cd_tbl_desc   
				    			  and b.cd_forma_pgto = int_cd_forma_pgto  
				    			    ) ;
	
		end if ;  
		
*/	   
     -------------------------------------------------------------------------------------------------------------------------------    
    --resultado final
    ------------------------------------------------------------------------------------------------------------------------------- 
	insert into rs_temp_return_rec
	select 
		  cd_tbl_desc,
		  perc_desc, 
		  perc_desc_max, 
		  tp_nivel
	from rs_tmp_desc 
	order by 
	   perc_desc desc ;
    -------------------------------------------------------------------------------------------------------------------------------    
    --retornando final
    ------------------------------------------------------------------------------------------------------------------------------- 
	for returnrec in 
			select cd_tbl_desc,perc_desc,perc_desc_max,tp_nivel 
			  from rs_temp_return_rec 
			  order by perc_desc desc limit 1
	loop		  
		return next returnrec;
	end loop;
end;

$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100
  ROWS 1000;
	ALTER FUNCTION public.ufd_est_prod_tbl_desc_pre_vencidos(integer, integer, character varying, integer)
  OWNER TO postgres;



CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_pre_vencidos(integer, integer, character varying)
RETURNS double precision AS
$body$
BEGIN
  RETURN ufd_est_prod_tbl_desc_pre_vencidos($1, $2, $3, 0);
END
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
PARALLEL UNSAFE
COST 100;